/*
 * Decompiled with CFR 0.152.
 */
package technology.rocketjump.undermount.assets;

import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.utils.Disposable;
import com.google.inject.Singleton;
import java.util.EnumMap;

@Singleton
public class TextureAtlasRepository
implements Disposable {
    private final EnumMap<TextureAtlasType, TextureAtlas> typeMap = new EnumMap(TextureAtlasType.class);

    public TextureAtlasRepository() {
        for (TextureAtlasType textureAtlasType : TextureAtlasType.values()) {
            this.typeMap.put(textureAtlasType, new TextureAtlas(new FileHandle("assets/tilesets/" + textureAtlasType.getFilename())));
        }
    }

    public TextureAtlas get(TextureAtlasType type) {
        return this.typeMap.get((Object)type);
    }

    @Override
    public void dispose() {
        this.typeMap.values().forEach(TextureAtlas::dispose);
    }

    public static enum TextureAtlasType {
        DIFFUSE_ENTITIES("diffuse-entities.atlas"),
        NORMAL_ENTITIES("normal-entities.atlas"),
        DIFFUSE_TERRAIN("diffuse-terrain.atlas"),
        NORMAL_TERRAIN("normals-terrain.atlas"),
        GUI_TEXTURE_ATLAS("gui.atlas"),
        MASKS_TEXTURE_ATLAS("masks.atlas");

        private final String filename;

        private TextureAtlasType(String filename) {
            this.filename = filename;
        }

        public String getFilename() {
            return this.filename;
        }
    }
}

